use master
GO

set nocount on 

--set to 0 to skip updating the A4Panel_Client_Template database, or to 1 to update the template database
declare @ProcessTemplateDB bit = 1  

declare @PanelClientPayload01 nvarchar(max) = N'
--DEV-75551
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N''[dbo].[VX_sp_ExportPanelists]'') AND type in (N''P'', N''PC''))
    DROP PROCEDURE [dbo].[VX_sp_ExportPanelists]
'

declare @PanelClientPayload02 nvarchar(max) = N'
CREATE PROCEDURE [dbo].[VX_sp_ExportPanelists]      
    @uid UNIQUEIDENTIFIER,
    @existsSubQuery NVARCHAR(MAX),
    @subset BIT = 0,
	@selectedSystemAttributeNames NVARCHAR(MAX) = NULL,
    @lastPanelistId INT,      
    @batchSize INT,      
    @convertToAge BIT = 0,      
    @daysSinceCompletion BIT = 0,      
    @daysSinceLastEmail BIT = 0,      
    @daysSinceLastActivity BIT = 0,      
    @daysSinceLastSampled BIT = 0,      
    @numberOfSamples BIT = 0,      
    @numberOfCompletedSurveys BIT = 0,       
    @numberOfParticipations BIT = 0,      
    @numberOfEmailsSent BIT = 0,      
    @numberOfSmsSent BIT = 0,      
    @placeholder NVARCHAR(MAX) = NULL,
	@enablePanelistTraceability BIT = 1
AS      
BEGIN      
    DECLARE @panelistIdsTableName NVARCHAR(MAX)
    DECLARE @stmt NVARCHAR(MAX)

    IF @subset = 0    
    BEGIN    
		SET @selectedSystemAttributeNames = ''*''
	END
	ELSE
	BEGIN
        IF @selectedSystemAttributeNames IS NULL OR @selectedSystemAttributeNames = ''''
        BEGIN
		    SET @selectedSystemAttributeNames = '' [Id]''
        END
        ELSE
        BEGIN
		    SET @selectedSystemAttributeNames = '' [Id],'' + @selectedSystemAttributeNames
        END
	END

    SET @panelistIdsTableName = ''##ExportPanelistIds_'' + REPLACE(CONVERT(NVARCHAR(36), @uid), ''-'', '''')
    SET @stmt = ''
    IF OBJECT_ID(''''tempdb..'' + @panelistIdsTableName + '''''') IS NULL
    BEGIN
        CREATE TABLE ['' + @panelistIdsTableName + ''] (
            [Id] INT NOT NULL PRIMARY KEY
        )
    END
    ELSE
    BEGIN
        TRUNCATE TABLE ['' + @panelistIdsTableName + ''] 
    END
    
    INSERT INTO ['' + @panelistIdsTableName + '']
    SELECT TOP(@batchSize) [Id]
	FROM ('' + @existsSubQuery + '') subQuery
	WHERE [Id] > @lastPanelistId
	ORDER BY [Id]
    
    SELECT '' + @selectedSystemAttributeNames

	IF @daysSinceCompletion = 1
	BEGIN
		SET @stmt = @stmt +      
		'',DATEDIFF      
		(      
			DAY      
			,(      
				SELECT       
					MAX(DateTime)       
				FROM [ActivityHistories] ah       
				JOIN [ActivityHistories_SurveyActivityHistory] sah ON sah.[Id] = ah.[Id]       
				WHERE ah.PanelistId = panelistA.[Id] AND sah.[DispositionCode] = 1      
			)       
			,GETUTCDATE()      
		) AS [DaysSinceCompletion]''  
	END

	IF @daysSinceLastEmail = 1
	BEGIN
		SET @stmt = @stmt +      
		'',DATEDIFF      
		(       
			DAY       
			,(      
				SELECT       
					MAX([SendDateTime])      
				FROM [ActivityHistories] ah      
				LEFT JOIN [ActivityHistories_EmailActivityHistory] eah ON eah.[Id] = ah.[Id]      
				LEFT JOIN [EmailInvitations] ei on ei.[Id] = eah.[EmailInvitationId]      
				WHERE ah.[PanelistId] = panelistA.[Id]      
			)      
			,GETUTCDATE()      
		) AS [DaysSinceLastEmail]''  
	END    
      
	IF @daysSinceLastActivity = 1
	BEGIN
		SET @stmt = @stmt +      
		'',DATEDIFF      
		(       
			DAY       
			,(      
				SELECT       
					Max([DateTime])       
				FROM [ActivityHistories] ah       
				JOIN [ActivityHistories_SurveyActivityHistory] sah ON sah.[Id] = ah.[Id]       
				WHERE ah.[PanelistId] = panelistA.[Id]      
			)      
			,GETUTCDATE()      
		) AS [DaysSinceLastActivity]''
	END
                  
	IF @daysSinceLastSampled = 1
	BEGIN
		SET @stmt = @stmt +      
		'',DATEDIFF      
		(       
			DAY       
			,(      
				SELECT DISTINCT       
					MAX(s.[ModifiedOn])      
				FROM [SamplePanelist] sp WITH(NOLOCK)      
				INNER JOIN [Samples] s WITH(NOLOCK) ON s.[Id] = sp.[Samples_Id]      
				WHERE sp.[Panelists_Id] = panelistA.[Id]      
			)      
			,GETUTCDATE()      
		) AS [DaysSinceLastSampled]'' 
	END     
      
	IF @numberOfSamples = 1
	BEGIN
		SET @stmt = @stmt +      
		'',(      
			SELECT DISTINCT       
				COUNT(*)       
			FROM [SamplePanelist] sp WITH(NOLOCK)      
			WHERE sp.[Panelists_Id] = panelistA.[Id]      
		) AS [NumberOfSamples]''
	END      
      
	IF @numberOfCompletedSurveys = 1
	BEGIN
		SET @stmt = @stmt +      
		'',(      
			SELECT COUNT(*)       
			FROM      
			(      
				SELECT DISTINCT       
					[SurveyId]      
					,[PanelistId]      
					,[DispositionCode]      
				FROM [ActivityHistories] ah      
				LEFT JOIN [ActivityHistories_SurveyActivityHistory] sah ON sah.[Id] = ah.[Id]      
				WHERE [PanelistId] = panelistA.[Id] AND [DispositionCode] = 1      
			) a      
		) AS [NumberOfCompletedSurveys]''
	END      
          
	IF @numberOfParticipations = 1
	BEGIN
		SET @stmt = @stmt +      
		'',(      
			SELECT       
				COUNT(*)       
			FROM       
			(      
				SELECT       
					[SurveyId]      
					,[PanelistId]      
				FROM [ActivityHistories] ah      
				LEFT JOIN [ActivityHistories_SurveyActivityHistory] sah ON sah.[Id] = ah.[Id]      
				WHERE [PanelistId] = panelistA.[Id] AND [DispositionCode] IS NOT NULL AND [DispositionCode] NOT IN (0, 6)      
				GROUP BY [SurveyId], [PanelistId]      
			) a      
		) AS [NumberOfParticipations]''  
	END    
      
	IF @numberOfEmailsSent = 1
	BEGIN
		SET @stmt = @stmt +      
		'',(      
			SELECT       
				COUNT(*)      
			FROM [ActivityHistories_EmailActivityHistory] eah      
			INNER JOIN [ActivityHistories] ah ON ah.[Id] = eah.[Id]      
			WHERE [PanelistId] = panelistA.[Id] AND [EmailInvitationStatus] = 1      
		) AS [NumberOfEmailsSent]'' 
	END     
      
	IF @numberOfSmsSent = 1
	BEGIN
		SET @stmt = @stmt +      
		'',(      
			SELECT       
				COUNT(*)      
			FROM [ActivityHistories] ah      
			INNER JOIN [ActivityHistories_SmsActivityHistory] sah on sah.[Id] = ah.[Id]      
			WHERE [PanelistId] = panelistA.[Id] AND [SmsInvitationStatus] = 1      
		) AS [NumberOfSmsSent]''
	END

	SET @stmt = @stmt + '' 
	FROM (
		SELECT
			[Id]
			,[Username]''      
          
    IF @placeholder IS NULL      
    BEGIN      
        SET @stmt = @stmt + ''
			,[FirstName]
			,[LastName]
			,[Email]
			,[Phone]''      
    END      
    ELSE      
    BEGIN      
        SET @stmt = @stmt + ''
			,@placeholder AS [FirstName]      
			,@placeholder AS [LastName]      
			,@placeholder AS [Email]      
			,@placeholder AS [Phone]''      
    END      
          
    SET @stmt = @stmt + ''
			,CASE [Gender]       
				WHEN 0 THEN ''''NotSpecified''''      
				WHEN 1 THEN ''''Male''''       
				WHEN 2 THEN ''''Female''''       
				ELSE ''''NotSpecified''''       
			END AS [Gender]''      
          
    IF @convertToAge = 1      
        SET @stmt = @stmt + '',(CONVERT(int,CONVERT(char(8),GETUTCDATE(),112))-CONVERT(char(8),[DateOfBirth],112))/10000 AS [Age]''      
    ELSE      
        SET @stmt = @stmt + '',[DateOfBirth]''      
          
    SET @stmt = @stmt + ''
			,CASE [IsAnonymized]       
				WHEN 1 THEN ''''Yes''''       
				ELSE ''''No''''       
			END AS [Anonymized]      
			,CASE [Status]       
				WHEN 0 THEN ''''Yes''''       
				WHEN 6 THEN ''''No''''       
				ELSE ''''NotSpecified''''       
			END AS [Active]      
			,[Points]      
			,[Language]      
			,[TimeZone]''
	IF @enablePanelistTraceability = 1
	BEGIN
		SET @stmt = @stmt + ''
			,[CreatedOn]
			,[ConfirmedOn]''
	END         

	SET @stmt = @stmt + ''
		FROM [Panelists] WITH (NOLOCK)
		WHERE [Id] IN (
			SELECT [Id]
            FROM ['' + @panelistIdsTableName + '']
		)
	) panelistA
	ORDER BY panelistA.[Id]''
          
    EXEC sp_executesql @stmt, N''@placeholder NVARCHAR(MAX), @lastPanelistId INT, @batchSize INT'', @placeholder, @lastPanelistId, @batchSize
END      
'

declare @PanelClientPayload03 nvarchar(max) = N'
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N''[dbo].[VX_sp_ExportAttributes]'') AND type in (N''P'', N''PC''))
    DROP PROCEDURE [dbo].[VX_sp_ExportAttributes]
'

declare @PanelClientPayload04 nvarchar(max) = N'
CREATE PROCEDURE [dbo].[VX_sp_ExportAttributes]     
    @uid UNIQUEIDENTIFIER,   
    @panelId INT,      
    @subset BIT = 0,
    @selectedAttributeIds NVARCHAR(MAX) = NULL
AS      
BEGIN
    DECLARE @attributesTableName NVARCHAR(MAX)
    DECLARE @stmt NVARCHAR(MAX)

	IF @selectedAttributeIds IS NULL      
    BEGIN    
		SET @selectedAttributeIds = ''''
	END

    SET @attributesTableName = ''##ExportAttributes_'' + REPLACE(CONVERT(NVARCHAR(36), @uid), ''-'', '''')
    SET @stmt = ''
    IF OBJECT_ID(''''tempdb..'' + @attributesTableName + '''''') IS NULL
    BEGIN
        CREATE TABLE ['' + @attributesTableName + ''] (
            [Id] INT NOT NULL PRIMARY KEY,
            [Name] NVARCHAR(255) NOT NULL,
            [IsAnonymizable] BIT NOT NULL
        )

        CREATE NONCLUSTERED INDEX [IX_'' + @attributesTableName + ''_Name]
        ON ['' + @attributesTableName + ''] ([Name])
    END
    ELSE
    BEGIN
        TRUNCATE TABLE ['' + @attributesTableName + ''] 
    END
    
    INSERT INTO ['' + @attributesTableName + '']
    SELECT [Id],
        CASE WHEN [Name] IN (''''Id'''', ''''Username'''', ''''FirstName'''',''''Lastname'''', ''''Email'''', ''''Phone'''', ''''Gender'''', ''''DateOfBirth'''', ''''Anonymized'''', ''''Active'''', ''''Points'''', ''''Language'''', ''''TimeZone'''', ''''CreatedOn'''', ''''ConfirmedOn'''')      
            THEN ''''_'''' + [Name]       
            ELSE [Name]       
        END, [IsAnonymizable]
	FROM [AttributeDefinitions] WITH(NOLOCK)       
    WHERE [PanelId] = @panelId
		AND (@subset = 0 OR (@selectedAttributeIds <> '''''''' AND [Id] IN (SELECT [Item] FROM dbo.SplitString(@selectedAttributeIds, '''',''''))))
    
    SELECT [Name]
    FROM ['' + @attributesTableName + '']
    ORDER BY [Name]''

    EXEC sp_executesql @stmt, N''@panelId INT, @subset BIT, @selectedAttributeIds NVARCHAR(MAX)'', @panelId, @subset, @selectedAttributeIds
END      
'

create table #DB (
	DBName nvarchar(128),
	Processed tinyint default 0
)

declare @AllDone bit = 0, 
        @TotalPanelClients int, 
		@PanelClientCounter int, 
		@ThisPanelClient nvarchar(128), 
		@PanelClientCursor cursor, 
		@DBSQL nvarchar(200), 
		@SQL nvarchar(max), 
		@StatusMessage varchar(max), 
		@StatusPercent tinyint

while @AllDone = 0 begin
	select @TotalPanelClients = 0, @PanelClientCounter = 0
	insert into #DB 
	select 'A4Panel_Client_' + cast(Id as nvarchar(16)), 0 
	       from Acuity4.dbo.Client
	       where DB_ID( 'A4Panel_Client_' + cast(Id as nvarchar(16)) ) IS NOT NULL

    if @ProcessTemplateDB = 1 
	   insert into #DB values (N'A4Panel_Client_Template', 0)

	select @TotalPanelClients = count(*) 
	       from #DB

	set @PanelClientCursor = cursor scroll dynamic for select DBName from #DB for update of Processed
	open @PanelClientCursor
	fetch next from @PanelClientCursor into @ThisPanelClient
	while @@FETCH_STATUS = 0 begin
		select @PanelClientCounter += 1
		select @DBSQL = @ThisPanelClient + N'.sys.sp_executesql'
		select @StatusMessage = 'Updating panel client database "%s" (%u of %u, %u%%)', @StatusPercent = 100.0 * @PanelClientCounter / @TotalPanelClients
		raiserror (@StatusMessage, 0, 1, @ThisPanelClient, @PanelClientCounter, @TotalPanelClients, @StatusPercent) with nowait
		
		select @SQL = replace(replace(@PanelClientPayload01, '#CLIENT ID#', substring(@ThisPanelClient, 16, 8)), '#CLIENT DB#', @ThisPanelClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		select @SQL = replace(replace(@PanelClientPayload02, '#CLIENT ID#', substring(@ThisPanelClient, 16, 8)), '#CLIENT DB#', @ThisPanelClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL
		
		select @SQL = replace(replace(@PanelClientPayload03, '#CLIENT ID#', substring(@ThisPanelClient, 16, 8)), '#CLIENT DB#', @ThisPanelClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		select @SQL = replace(replace(@PanelClientPayload04, '#CLIENT ID#', substring(@ThisPanelClient, 16, 8)), '#CLIENT DB#', @ThisPanelClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		update #DB set Processed = 1 where current of @PanelClientCursor
		fetch next from @PanelClientCursor into @ThisPanelClient
	end


	close @PanelClientCursor
	deallocate @PanelClientCursor

-- Backup client template db if it was updated
	IF @ProcessTemplateDB = 1 
    BEGIN
      PRINT 'Creating backup for A4Panel_Client_Template';
      SET @SQL = 'USE A4Panel;
                  exec [dbo].[VX_sp_BackupClientTemplateDatabase]'
      EXEC (@SQL); 
    END

    SELECT @AllDone = 1
end



--select * from #DB
--select * from #Survey

drop table #DB
